import numpy as np


def profile_to_np_matrix(profile, num_candidates, num_voters):
    matrix = np.zeros([num_voters, num_candidates])
    mapping = {}
    for i, vote in enumerate(profile):
        for c in vote:
            if c not in mapping:
                mapping[c] = len(mapping)
            matrix[i][mapping[c]] = 1
    return matrix, mapping

